﻿IF EXISTS (SELECT * FROM sys.procedures WHERE object_id = object_id(N'[dbo].[swrGetFileScan]') AND type = 'P')
	DROP PROCEDURE [dbo].[swrGetFileScan]
GO

--------------------------------------------------------------------------------
-- SoftwareRecognition - GenericDataConnector
--------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[swrGetFileScan] 
	@identifier --<typ entsprechend der Worklist>                       
AS
BEGIN
	SELECT	  s.Manufacturer	-- nvarchar(256)
			, s.ProductName		-- nvarchar(256)
			, s.ProductVersion	-- nvarchar(256)
			, s.FileName		-- nvarchar(256)
			, s.FileDescription	-- nvarchar(512)
			, s.FileSize		-- bigint
			, s.FilePath		-- nvarchar(512)
	FROM [<dataSource>] s, 
	WHERE s.Identifier = @identifier
END
GO