﻿IF EXISTS (SELECT * FROM sys.procedures WHERE object_id = object_id(N'[dbo].[swrGetHardwareScan]') AND type = 'P')
	DROP PROCEDURE [dbo].[swrGetHardwareScan]
GO

--------------------------------------------------------------------------------
-- SoftwareRecognition - GenericDataConnector
--------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[swrGetHardwareScan] 
	@identifier --<typ entsprechend der Worklist>     
AS
BEGIN
	SELECT	
		  ScanDate				-- datetime
		, Manufacturer			-- nvarchar(100)
		, Model					-- nvarchar(100)
		, Model2				-- nvarchar(100)
		, ServiceTag			-- nvarchar(100)
		, Serial				-- nvarchar(100)
		, Mac1					-- nvarchar(100)
		, Mac2					-- nvarchar(100)
		, Mac3					-- nvarchar(100)
		, Mac4					-- nvarchar(100)
		, ChassisType			-- int
		, DeviceChassis			-- nvarchar(100)
									--> Values: 
										--		 'Other'
										--		 'Unknown'
										--		 'Desktop'
										--		 'Low Profile Desktop'
										--		 'Pizza Box'
										--		 'Mini Tower'
										--		 'Tower'
										--		 'Portable'
										--		 'Laptop'
										--		 'Notebook'
										--		 'Hand Held'
										--		 'Docking Station'
										--		 'All in One'
										--		 'Sub Notebook'
										--		 'Space-Saving'
										--		 'Lunch Box'
										--		 'Main System Chassis'
										--		 'Expansion Chassis'
										--		 'Sub Chassis'
										--		 'Bus Expansion Chassis'
										--		 'Peripheral Chassis'
										--		 'Storage Chassis'
										--		 'Rack Mount Chassis'
										--		 'Sealed-Case PC'
										--		 'Unknown'
		, ProcessorManufacturer	-- nvarchar(100)
		, ProcessorType			-- nvarchar(256)
		, ProcessorSpeed		-- int
		, CPUCount				-- int
		, CPUCoreCount			-- int
		, CorePerCPU			-- int
		, CPULogicalCount		-- int		
		, Type					-- nvarchar(100)
		, Class					-- nvarchar(100)
		, DiskTotalMB			-- int
		, DiskFreeMB			-- int
		, GraphicAdapter		-- nvarchar(100)
		, GraphicMemoryMB		-- int
		, MemoryMB				-- int
		, IPAddressV4			-- varchar(15)
		, IPAddressV6			-- varchar(50)
		, CPUArchitecture		-- nvarchar(100)
		, OSCaption				-- nvarchar(100)
		, LastLoggedOnUser		-- nvarchar(100)
		, BIOSVendor			-- nvarchar(100)
		, BIOSVersion			-- nvarchar(100)
		, BIOSDate				-- datetime
		, InventorySource		-- nvarchar(100)
		, LegalEntity			-- nvarchar(500)
		, Parameter01			-- nvarchar(100)
		, Parameter02			-- nvarchar(100)
		, Parameter03			-- nvarchar(100)
		, Parameter04			-- nvarchar(100)
		, Parameter05			-- nvarchar(100)
										
	FROM [<datasource>] h		
	WHERE h.Identifier = @identifier
END
GO



