﻿IF EXISTS (SELECT * FROM sys.procedures WHERE object_id = object_id(N'[dbo].[swrGetSoftwareScan]') AND type = 'P')
	DROP PROCEDURE [dbo].[swrGetSoftwareScan]
GO

--------------------------------------------------------------------------------
-- SoftwareRecognition - GenericDataConnector
--------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[swrGetSoftwareScan] 
	@identifier --<typ entsprechend der Worklist>  
AS
BEGIN
	SELECT
		  Manufacturer			-- nvarchar(256)
		, SoftwareName			-- nvarchar(256)
		, SoftwareVersion		-- nvarchar(256)
		, LicenceRequirement	-- decimal(18,4)
		, SerialNo				-- nvarchar(100)
		, InstallDate			-- datetime
	FROM [<dataSource>] 
	WHERE Identifier = @identifier
	
END
GO


