﻿IF EXISTS (SELECT * FROM sys.procedures WHERE object_id = object_id(N'[dbo].[swrGetSwidScan]') AND type = 'P')
	DROP PROCEDURE [dbo].[swrGetSwidScan]
GO

--------------------------------------------------------------------------------
-- SoftwareRecognition - GenericDataConnector
--------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[swrGetSwidScan] 
	@identifier --<typ entsprechend der Worklist>  
AS
BEGIN
	SELECT
          SWCreatorName     -- nvarchar(256)
        , SWCreatorRegID    -- nvarchar(256)
        , Product_title     -- nvarchar(256)
        , Product_version   -- nvarchar(256)
        , SWLicensorName    -- nvarchar(256)
        , SWLicensorRegID   -- nvarchar(256)    (optional)
        , SoftwareUnique    -- nvarchar(256)
        , SoftwareRegID     -- nvarchar(256)    (optional)
        , TAGCreatorName    -- nvarchar(256)    (optional)
        , TAGCreatorRegID   -- nvarchar(256)    (optional)
        , LicenseActivation -- nvarchar(256)    (optional)
        , LicenseChannel    -- nvarchar(256)
        , LicenseCustomer   -- nvarchar(256)    (optional)
        , SerialNumber      -- nvarchar(256)

	FROM [<dataSource>] 
	WHERE Identifier = @identifier
	
END
GO