﻿IF EXISTS (SELECT * FROM sys.procedures WHERE object_id = object_id(N'[dbo].[swrGetWorklist]') AND type = 'P')
	DROP PROCEDURE [dbo].[swrGetWorklist]
GO

--------------------------------------------------------------------------------
-- SoftwareRecognition - GenericDataConnector
--------------------------------------------------------------------------------
-- swrGetWorklist liefert einen Identifier entsprechend dem aktuellen System.
-- Dies kann eine ID (int) ein GUID oder auch ein anderes eindeutiges Merkmal sein.
-- Zusätzlich zu dem Identifier werden die übrigen für die Identifikation 
-- eines Devices möglichen Felder zurückgegeben.
-- 
-- Der Identifier muß in der ersten Column zurückgegeben werden!
--------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[swrGetWorklist] 
AS
BEGIN
	SELECT	  Identifier    -- kein festgelegter Typ (int, bigint, uniqueidentifier, ...) 
			, UUID          -- uniqueidentifier
			, Urn           -- nvarchar(100)
			, Domain	    -- nvarchar(100)
			, Hostname      -- nvarchar(100)
			, DomainNetBIOS -- nvarchar(100)
	FROM [<dataSource>] 
END
GO


